#!/usr/bin/perl

use warnings;
use utf8;
use SOAP::Lite;
use Encode;
use XML::Simple;
use MIME::Base64;
use LWP;

BEGIN {
	$ENV{PERL_NET_HTTPS_SSL_SOCKET_CLASS} = "Net::SSL";
	$ENV{PERL_LWP_SSL_VERIFY_HOSTNAME} = 0;
} 

if($ENV{'SHELL'}){
    if($ENV{'SHELL'} =~ /(bash|console)/i){
        $ANSI = 1;
        use Term::ANSIColor;
    }
}

$DOWARN = 1;
BEGIN { $SIG{'__WARN__'} = sub { warn $_[0] if $DOWARN } }


#defaults
$user='';
$realm='';
$pwd='';
$def_wsdl = 'file:/var/lib/aosi/www/aosi.wsdl';

#boje
$input_c = 'bold green';
$info_c = 'bold red';
$default_c = 'bold yellow';
$err_c = 'bold red';



$out = '';

$LWP_ver=$LWP::VERSION;
$soap_ver = $SOAP::Lite::VERSION;
safe_print("LWP version: $LWP_ver\n", $info_c);
safe_print("SOAP::Lite version: $soap_ver\n", $info_c);

$user = getstg('uid', $user);

system("stty -echo");
$pwd = getstg('zaporka', $pwd);
system("stty echo");

$pwd = encode_base64($pwd);
chomp($pwd);
print "\n";
$realm = getstg("domena", $realm);
$wsdl = getstg('wsdl', $def_wsdl);

my @tmp_base = split(/\./, $realm);
my @tmp_uid = split(/@/,$user);

$user=$tmp_uid[0];
$realm=$tmp_base[0];

$base_dn = 'dc=' . $realm . ',dc=hr';

#our $s = SOAP::Lite->proxy('https://aosi-dev.srce.hr:1443/AOSI', timeout => 5 )->uri('AOSI')->on_fault(
our $s = SOAP::Lite->service($wsdl)->on_fault(
    sub {
        my ($soap, $res) = @_;
        $out = ref $res ? $res->faultstring : $soap->transport->status;
        safe_print("Greska: $out", $default_c);
        exit();
        #die ref $res ? $res->faultstring : $soap->transport->status,"\n";
    }
);
$s->soapversion('1.1');
#$s->envprefix('SOAP-ENV');

safe_print("\n****Dohvacam podatake o neispravnim zapisima*****\n", $default_c);
my ($code, $error, $result) = $s->ldapSearch($user, $pwd, $base_dn, '(&(uid=*)(!(hrEduPersonUniqueNumber=*OIB*))(!(hrEduPersonOIB=NONE)))', 'hrEduPersonOIB');

our %entries;
our $wrong;

if($code!=0){
	safe_print(" greska: $code: $error", $err_c);
} else {
	$xml = XMLin($result, ForceArray => [ 'entry', 'attribute', 'value' ]);
	foreach $ent (@{ $xml->{'entry'} }) {
		my $dn=$ent->{'dn'};
	    foreach $attr (@{ $ent->{'attribute'} }) {
	        if($attr->{'ldapname'} eq 'hrEduPersonOIB'){
	        	my $vals = $attr->{'value'};
	        	$entries{$dn}=$vals->[0];
	        	print $dn . "\n";
	        }
	    }
	}
}
our $xml_update='<ldap>';
$i=0;
foreach my $dn ( keys %entries )
{
	$i++;
	$xml_update.='<entry dn="' . $dn . '"><attribute ldapname="hrEduPersonUniqueNumber"><value>OIB: ' . $entries{$dn} . '</value></attribute></entry>';
}
if($i>0){
	safe_print("****Ispravljam neispravne zapise.*****\n", $default_c);
	$xml_update.='</ldap>';
	($code, $error, $result) = $s->ldapAddAttribute($user, $pwd, $base_dn, $xml_update);
	if($code==0){
		safe_print("Podaci ispravljeni za sve korisnike:\n", $default_c);
		my @res=process_search_result($result);
		foreach my $r (@res){
			print "$r\n";
		}
	} else {
		safe_print("Prilikom ispravljanja podataka doslo je do greske!\n", $err_c);
		safe_print("Kod greske: " . nvl($code) . "\n", $err_c);
		safe_print("Opis greske: " . nvl($error) . "\n", $err_c);
		print "Detalji:\n\n";
		my $res_ref=process_add_result($result);
		my @res = @$res_ref;
		foreach my $r (@res){
			print $r->[0] . ":";
			if($r->[1]==0){
				print " OIB dodan.";
			} else {
				safe_print(" greska: " . $r->[2], $err_c);
			}
			if($r->[3]!=0){
				safe_print(", greska prije plugina: " . $r->[4], $err_c);
			}
			if($r->[5]!=0){
				safe_print(", greska poslije plugina: " . $r->[6], $err_c);
			}
			print "\n";
		}
	}
} else {
	safe_print("****U imeniku nisu pronadjeni neispravni zapisi.*****\n", $default_c);
}
exit();

sub valid_oib {
	return 0 unless $_[0] =~ /^\d{11}$/;
	my @chars = split(//, $_[0]);
	my $P = 10;
	my $S;
	for my $a (@chars) {
		$S = $P%11 + $a;
		$P = ($S%10 || 10) * 2;
	}
	return $S%10 == 1;
}
sub valid_jmbg {
	return 0 unless $_[0] =~ /^\d{13}$/;
	my @c = split(//, $_[0]);
	my $S=0;
	for (my $i=0;$i<6;$i++){
		$S+= (7-$i)*($c[$i]+$c[6+$i]);
	}
	return 11-($S%11) == $c[12];
}

sub utfize {
    my ($value) = @_;
    utf8::decode($value);
    if($LWP_ver<'5.810'){
    	return $value;
    } else {
    	return encode("utf-8",$value);
    }
}

sub utf_to_iso {
    my ($value) = @_;
   # encode("iso-8859-1",$value);
    return encode("iso-8859-1",$value);
}

sub nvl {
    my ($in, $val) = @_;
    my ($out);

    $out = $in;
    $val = defined $val ? $val : '';
    $out = defined $out ? $out : $val;
    return $out;
}

sub process_add_result {
    my ($xml_in) = @_;
    my ($xml, $out, $ent, $attrs, $status, $bstatus, $astatus);
    my ($attr, $key, $val, $vals, $name, $code);

    my @out;

    if($xml_in){
        $xml = XMLin($xml_in, ForceArray => [ 'entry', 'attribute', 'value', 'status', 'before_plugin_status', 'after_plugin_status' ], KeyAttr => []);

        foreach $ent (@{ $xml->{'entry'} }) {
        	my @e;
        	
        	my $status_code=0;
        	my $before_code=0;
        	my $after_code=0;
        	my ($dn,$status_mess,$before_mess,$after_mess);
            $dn = $ent->{'dn'};
            $status  = $ent->{'status'};
            $bstatus = $ent->{'before_plugin_status'};
            $astatus = $ent->{'after_plugin_status'};
            if (ref($bstatus) eq 'ARRAY') {
                foreach $key (@$bstatus) {
                    $name = $key->{'name'};
                    $code =$key->{'code'};
                    $val  = $key->{'content'};
                    if($code!=0){
                    	$before_code=1;
                    }
                    $before_mess.="plugin: $name, kod: $code, " . nvl($val, '-');
                }
            }
            if (ref($status) eq 'ARRAY') {
                foreach $key (@$status) {
                    $code = $key->{'code'};
                    $val  = $key->{'content'};
                    if($code!=0){
                    	$status_code=1;
                    }
                	$status_mess.="kod: $code, " . nvl($val, '-');
                }
            }
            if (ref($astatus) eq 'ARRAY') {
                foreach $key (@$astatus) {
                    $name = $key->{'name'};
                    $code = $key->{'code'};
                    $val  = $key->{'content'};
                   	if($code!=0){
                    	$after_code=1;
                    }
                    $after_mess.="plugin: $name, kod: $code, " . nvl($val, '-');
                }
            }
            @e=($dn,$status_code,$status_mess,$before_code,$before_mess,$after_code,$after_mess);
            push @out,\@e;
        }
    }
    return \@out;
}

sub process_search_result {
    my ($xml_in) = @_;
    my ($xml, @out, $ent);

    $out = "\n";

    if($xml_in){
        $xml = XMLin($xml_in, ForceArray => [ 'entry', 'attribute', 'value', 'status', 'before_plugin_status', 'after_plugin_status' ], KeyAttr => []);
        foreach $ent (@{ $xml->{'entry'} }) {
            my $dn = $ent->{'dn'};
            push @out,$dn;
        }
    }
    return @out;
}
sub process_org_result {
    my ($xml_in) = @_;
    my ($xml, $ver);

    if($xml_in){
        $xml = XMLin($xml_in, ForceArray => ['entry', 'attribute', 'value', 'status', 'before_plugin_status', 'after_plugin_status'], KeyAttr => [], KeepRoot => 1);
        $ver = $xml->{'ldap'}->{'version'}; 
    }
    return $ver;
}
sub dump_to_file {
    my ($stg) = @_;
    open(LOG, ">>ac.log") or die "cannot log to ac.log ($!)\n";
    print LOG $stg;
    close(LOG);
}

sub getstg {
    my($label, $default) = @_;
    my($out, $ans, $spc);

    $spc = $label ne '' ? ' ' : '';

    print $label.$spc."[";
    if($ANSI){
        $Term::ANSIColor::AUTORESET = 1;
        safe_print("$default", $default_c);
    }
    else {
        print "$default";
    }
    print "]: ";
    if($ANSI){
        print color $input_c;
    }
    $out = $default;
    chomp($ans = <STDIN>);
    if ($ans ne '') {
        $out = $ans;
    }
    if($ANSI){
        print color 'reset';
    }

    return $out;
}

sub safe_print {
    my($stg, $color) = @_;

    if($ANSI){
        print colored ($stg, $color);
    }
    else {
        print $stg;
    }
}
